#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Clubfridge - das digital abbuchende Kühlschrankschloss für Vereine und Gemeinschaften
# Bootstrap routine für Erstinstallation von Kassen

# (c) 2017,2018 Torsten Beyer
#
# Version   Datum     Beschreibung
# V0.1      22.10.17   Erste funktionierende Version
# V.02      27.04.19   Erweiterung für Kunden, die nicht vereinsflieger benutzen

import ConfigParser
import re
import shutil
import os


if os.geteuid() != 0:
    print "Dieses Skript muß mit Root-Rechten laufen, weil SW installiert wird"
    print "Bitte nochmal sudo bootstrap.py versuchen"
    exit(0)

print "Bootstrap Routine für die Erstinstallation von Clubfridge"
print "Wir brauchen gleich Deine Vereinsflieger Club ID (CID)"
print "Wir brauchen einen Namen für diese Kasse - idealerweise heissen alle Kassen in Deinem Verein unterschiedlich"
print "Basierend auf diesen Daten generiert das Bootstrap Skript eine ID für diese Kasse"
print "Damit verbindet sich die Kasse mit dem Clubfridge Server, identifiziert sich und"
print "lädt nach erfolgreicher Identifikation die clubfridge software samt installations-skript herunter"
print "Wenn Dein Display auf dem Kopf steht, dreht dieses Bootstrap skript auch Dein Display"
print "Dein Raspi muß mit dem Internet verbunden sein!"

ok = ""
while ok != 'j' and ok != 'n':
    ok = raw_input("Bist Du bereit (j/n) ")


if ok == 'n':
    exit(0)
else:
    input_good = False

    while not input_good:
        upside_down = ""
        while upside_down != 'j' and upside_down != 'n':
            upside_down = raw_input("Steht das Display Kopf (j/n) ")

        vereinsflieger = ""

        while vereinsflieger != "j" and vereinsflieger != "n":
            vereinsflieger = raw_input("Benutzt Du vereinsflieger? (j/n) ")

        if vereinsflieger == "j":
            cid = 0
            while cid == 0:
                try:
                    cid = int(raw_input("Wie lautet Deine Vereinsflieger ClubID (CID, nur Ziffern)? "))
                except ValueError:
                    print('Du sollst eine Zahl eingeben!')
                    cid = 0
        else:
            cid = 0
            while cid == 0:
                try:
                    cid = int(raw_input("Wie lautet Deine Clubfridge ClubID (nur Ziffern)? "))
                except ValueError:
                    print('Du sollst eine Zahl eingeben!')
                    cid = 0


        name = ' '
        while name.count(' ') > 0:
            name = raw_input("Wie soll diese Kasse heißen? (keine blanks!) ")


        print "Zusammenfassung:"
        print "Display steht Kopf: %s" %(upside_down)
        if vereinsflieger == "j":
            print "Vereinsflieger CID: %s" % (cid)
        else:
            print "Clubfridge ClubID: %s" % (cid)

        print "Name dieser Kasse %s" % (name)

        summary_ok = ''
        while summary_ok != 'j' and summary_ok != 'n':
            summary_ok = raw_input("Sind diese Daten richtig? (j/n)")

        input_good = summary_ok == 'j'

if vereinsflieger == "j":
    salt_minion_name = "%s.%d.vf.clubfridge" % (name, cid)
else:
    salt_minion_name = "%s.%d.cf.clubfridge" % (name, cid)

if upside_down == 'j':
    print "Drehe Display (wirkt erst nach Neustart - kommt am Ende"
    os.system('echo "lcd_rotate=2" >> /boot/config.txt')

print "Aktualisiere das Betriebssystem - das kann eine Weile dauern"

os.system('apt-get update')
os.system('apt-get upgrade')

print "Installiere Salt"

os.system('apt-get install salt-minion')

os.system('cat /etc/salt/minion | sed s/^#master:.\*\$/master:\ clubfridge.com/ > /tmp/minion.new')
os.system('cat /tmp/minion.new | sed s/^#id:.\*\$/id:\ %s/ > /etc/salt/minion' % (salt_minion_name))

print "Dein System ist soweit vorbereitet. Jetzt kommt ein reboot und dann kommt die Clubfridge SW auf Deinen Rechner"

os.system('reboot')
